/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xio32.c 
 * -----------------------------------------------------------------*/

/* SCR; 29.10.97; this file contains simple read/write (i.e. I/O) functions
 * that are operating-system dependent....in this case Win32 ONLY.
 * NOTE; Until all Win95 drivers are true 32-bit (i.e. use CreateFile())
 * we use defines here to bring in the DOS drivers.
 */

/* --------------------------------------------------------------------------
 * IMPORTANT; Read the notes on RegWidth in bx_io.h
 *            DO NOT check the real connection within BestXBasicRead() or Write()
 *            That could be recursive (and would be very bad).
 *            The handle connection check is a flag and thus OK.
 * -------------------------------------------------------------------------- */


#if !defined(AIX) && !defined(_AIX)
#include <windows.h>
#include <winioctl.h>
#include <b_hif.h>
#include <xwdmusb.h>
#include <xhif.h>
#include <xusb.h>
#endif

#include <xtypedef.h>
#include <xutil.h>

#include <xerrcapi.h>
#include <xsession.h>

#include <xio.h>
#include <xpci.h>
#include <xlasterr.h>


#ifdef __BORLANDC__
#pragma inline
#endif

#include <xezusbsy.h>

/* --------------------------------------------------------------------------
 * Reads a stream of bytes from the port...NO BYTE ORDERING DONE HERE !!!
 * This function has no knowledge of registers.
 * -------------------------------------------------------------------------- */

bx_errtype BestXBasicRead(
    bx_handletype handle,
    bx_int8 * pData,
    bx_int32 NumBytes,
    bx_int8 RegWidth)
{
  BX_TRY_VARS;
  BULK_TRANSFER_CONTROL bulkControl;
  bx_int32 BytesRead = 0, BytesLeft = 0;
  bx_int32 result;
  
  bx_portnumtype OsHandle = bx_handlearray[handle].portnumber;

  BX_TRY_BEGIN
  {
    if (NumBytes)
    {
      BX_TRY_FAIL(BestXIsHandleConnected(handle) ? BX_E_OK : BX_E_NOT_CONNECTED);

      assert(pData);
      assert(((NumBytes % RegWidth) == 0) && "Boundary violation in BestXBasicRead()");

      /* must set (or at least check) the reg. width */
      (void) BestXRegwidthSet(handle, RegWidth);

      switch (bx_handlearray[handle].port)
      {
        case BX_PORT_OFFLINE:
          BESTX_MEMSET(pData, 0, NumBytes);
          break;

#ifdef DOSW32
        case BX_PORT_FASTHIF:
        case BX_PORT_PARALLEL: 
        case BX_PORT_USB:
        case BX_PORT_PCI_CONF:
        case BX_PORT_PCI_IO:
        case BX_PORT_RS232:
        break;
#else
      
        case BX_PORT_FASTHIF:
          if (BestXIsInDirectMode(handle))
          {
            /* use the block (direct) mode read */
            BX_TRY_PROGRESS(BestXHIFIoCtlRead(handle, pData,
                            NumBytes,&BytesRead,IOCTL_HIF_READ_DIRECT));
            break;
          }
  
        case BX_PORT_PARALLEL: 
        case BX_PORT_PCI_CONF:
        case BX_PORT_PCI_IO:
        case BX_PORT_RS232:
            BytesLeft=NumBytes;
            do
            {
              result=ReadFile(OsHandle, pData, BytesLeft, &BytesRead, NULL);  /* Win2k/NT/XP: Always transfers all data, even though it doesn't fit into sendbuffer.
                                                                                              Doesn't return after before having transfered all data, so normally no error
                                                                                 Win98: Returns with error after transfering the maximum-buffer-size, even though there's more data
                                                                                        to transfer. Operation has to be restartet with an apropriate offset */
              if (!result && (BytesRead==0))                /* This is only an error if no data is has been transfered */
              {
                BX_TRY_PROGRESS(BX_E_INTERNAL_RETURN);
              }
              
              BytesLeft-=BytesRead;
              pData+=BytesRead;
            } while (BytesLeft && BytesRead);
            
            if (BytesLeft)
            {
              /* BytesRead==0 */
              BX_TRY_FAIL(BX_E_INTERNAL_RETURN);
            }
            break;
        case BX_PORT_USB:

        if (bx_handlearray[handle].entered_port>=BX_USB_PORTNUM_OFFSET)
        {
            /* copied from above */
            BytesLeft=NumBytes;
            do
            {
              result=ReadFile(OsHandle, pData, BytesLeft, &BytesRead, NULL);  /* Win2k/NT/XP: Always transfers all data, even though it doesn't fit into sendbuffer.
                                                                                              Doesn't return after before having transfered all data, so normally no error
                                                                                 Win98: Returns with error after transfering the maximum-buffer-size, even though there's more data
                                                                                        to transfer. Operation has to be restartet with an apropriate offset */
              if (!result && (BytesRead==0))                /* This is only an error if no data is has been transfered */
              {
                BX_TRY_PROGRESS(BX_E_INTERNAL_RETURN);
              }
              
              BytesLeft-=BytesRead;
              pData+=BytesRead;
            } while (BytesLeft && BytesRead);
            
            if (BytesLeft)
            {
              /* BytesRead==0 */
              BX_TRY_FAIL(BX_E_INTERNAL_RETURN);
            }
        }
        else
        {
          BytesLeft=NumBytes;
            do
            {
              if (BestXIsInDirectMode(handle))
              {
                bulkControl.pipeNum = 2; /* 2=EP6: IN, 16 bit */
              }
              else
              {
                bulkControl.pipeNum = 0; /* 0=EP2: IN, 8 bit */
              }

              /* Perform the BULK IN */
              result = DeviceIoControl (OsHandle,
                         IOCTL_EZUSB_BULK_READ,
                         &bulkControl,
                         sizeof(BULK_TRANSFER_CONTROL),
                         pData,
                         BytesLeft,
                         &BytesRead,
                         NULL);
              if (!result && (BytesRead==0))                /* This is only an error if no data is has been transfered */
              {
                BX_TRY_PROGRESS(BX_E_INTERNAL_RETURN);
              }
              
              BytesLeft-=BytesRead;
              pData+=BytesRead;
            } while (BytesLeft && BytesRead);
            
            if (BytesLeft)
            {
              /* BytesRead==0 */
              BX_TRY_FAIL(BX_E_INTERNAL_RETURN);
            }
        }         
            break;


#endif /* DOSW32 */

        default:
          BX_TRY_ERROR(BX_E_INVALID_CASE);
      } /* switch */
    }
  }

  BX_TRY_CATCH
  {
    DBG_ApiLastError;         /* no harm if error was not from Windows */
    BestXLastErrorParamSet(handle, BX_ERRPAR_1, BX_EERR_READ_WRITE);
    BestXLastErrorParamStringSet(handle,"Read function returned an error."); 
    BX_TRY_RET = BX_E_TRANSF_CMD;
  }

  return BX_TRY_RET;
}


/* --------------------------------------------------------------------------
 * Writes a stream of bytes to the port...NO BYTE ORDERING DONE HERE !!!
 * This function has no knowledge of registers.
 * -------------------------------------------------------------------------- */

bx_errtype BestXBasicWrite(
    bx_handletype handle,
    bx_int8 * pData,
    bx_int32 NumBytes,
    bx_int8 RegWidth)
{
  BX_TRY_VARS;
  BULK_TRANSFER_CONTROL bulkControl;
  bx_int32 BytesWritten = 0, BytesLeft = 0;
  bx_portnumtype OsHandle = bx_handlearray[handle].portnumber;
  bx_int32 result;
  
  BX_TRY_BEGIN
  {
    if (NumBytes)
    {
      BX_TRY_FAIL(BestXIsHandleConnected(handle) ? BX_E_OK : BX_E_NOT_CONNECTED);

      assert(pData);
      assert(((NumBytes % RegWidth) == 0) && "Boundary violation in BestXBasicWrite()");

      /* must set (or at least check) the reg. width */
      (void) BestXRegwidthSet(handle, RegWidth);

      switch (bx_handlearray[handle].port)
      {
      case BX_PORT_OFFLINE:
        break;

      case BX_PORT_FASTHIF:
        if (BestXIsInDirectMode(handle))
        {
          /* use the block (direct) mode write */
          BX_TRY_PROGRESS(BestXHIFIoCtlWrite(handle, pData,
              NumBytes, &BytesWritten,
              IOCTL_HIF_WRITE_DIRECT));
          break;
        }

        /* NT FastHif Controlled IO is a deliberate flow into next case */

      case BX_PORT_PARALLEL:     /* all flow-throughs if not 95 */
      case BX_PORT_PCI_CONF:
      case BX_PORT_PCI_IO:

#ifndef DOSW32
      case BX_PORT_RS232:
          BytesLeft=NumBytes;
          do {
              result=WriteFile(OsHandle, pData, BytesLeft, &BytesWritten, NULL);  /* Win2k/NT/XP: Always transfers all data, even though it doesn't fit into sendbuffer.
                                                                                                  Doesn't return after before having transfered all data, so normally no error
                                                                                     Win98: Returns with error after transfering the maximum-buffer-size, even though there's more data
                                                                                            to transfer. Operation has to be restartet with an apropriate offset */
              if (!result && (BytesWritten==0))                /* This is only an error if no data is has been transfered */
              {
                /* Error occured */
                BX_TRY_PROGRESS(BX_E_INTERNAL_RETURN);
              }
              BytesLeft-=BytesWritten;
              pData+=BytesWritten;
          } while (BytesLeft && BytesWritten);

          if (BytesLeft) 
          {
            BX_TRY_ERROR(BX_E_INTERNAL_RETURN);
          }
        break;
      case BX_PORT_USB:
         if (bx_handlearray[handle].entered_port>=BX_USB_PORTNUM_OFFSET)
         {
          /* copied from above */
          BytesLeft=NumBytes;
          do {
              result=WriteFile(OsHandle, pData, BytesLeft, &BytesWritten, NULL);  /* Win2k/NT/XP: Always transfers all data, even though it doesn't fit into sendbuffer.
                                                                                                  Doesn't return after before having transfered all data, so normally no error
                                                                                     Win98: Returns with error after transfering the maximum-buffer-size, even though there's more data
                                                                                            to transfer. Operation has to be restartet with an apropriate offset */
              if (!result && (BytesWritten==0))                /* This is only an error if no data is has been transfered */
              {
                /* Error occured */
                BX_TRY_PROGRESS(BX_E_INTERNAL_RETURN);
              }
              BytesLeft-=BytesWritten;
              pData+=BytesWritten;
          } while (BytesLeft && BytesWritten);

          if (BytesLeft) 
          {
            BX_TRY_ERROR(BX_E_INTERNAL_RETURN);
          }
         }
         else
         {
            BytesLeft=NumBytes;
            do
            {
              if (BestXIsInDirectMode(handle))
              {
                bulkControl.pipeNum = 3; /* 3=EP8: OUT, 16 bit */
              }
              else
              {
                bulkControl.pipeNum = 1; /* 1=EP4: OUT, 8 bit */
              }
              /* Perform the BULK OUT */
              result = DeviceIoControl (OsHandle,
                         IOCTL_EZUSB_BULK_WRITE,
                         &bulkControl,
                         sizeof(BULK_TRANSFER_CONTROL),
                         pData,
                         BytesLeft,
                         &BytesWritten,
                         NULL);
              if (!result && (BytesWritten==0))                /* This is only an error if no data is has been transfered */
              {
                BX_TRY_PROGRESS(BX_E_INTERNAL_RETURN);
              }
              
              BytesLeft-=BytesWritten;
              pData+=BytesWritten;
            } while (BytesLeft && BytesWritten);
            
            if (BytesLeft)
            {
              /* BytesWritten==0 */
              BX_TRY_FAIL(BX_E_INTERNAL_RETURN);
            }
         }
         break;

#endif /* DOSW32 */

      default:
            BX_TRY_ERROR(BX_E_INVALID_CASE);
      } /*lint !e788 ... not all enums used */
    }
  }

  BX_TRY_CATCH
  {
      DBG_ApiLastError;         /* no harm if error was not from Windows */
      BestXLastErrorParamSet(handle, BX_ERRPAR_1, BX_EERR_READ_WRITE);
      BestXLastErrorParamStringSet(handle,"Write function returned an error");
      BX_TRY_RET = BX_E_TRANSF_CMD;
  }

  return BX_TRY_RET;
}
